#NoTrayIcon

#include <EditConstants.au3>
#include <ListViewConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#include <GUIConstantsEx.au3>
#include <GUIListView.au3>
#include <Misc.au3>
#include <WinAPI.au3>
#include 'TCPInet.au3'

Opt('GUICloseOnESC', 0)

Global $iLV_ITEM = -1
Global $fLV_UPDATED = False
Global $aButtons[3] = [0]

Global Enum _
	$iBttn_Download, $iBttn_Pause, $iBttn_Remove, _
	$iBttn_Total

$hForm = GUICreate('TCPInet UDF Example', 760, 440)
GUICtrlCreateListView('', 0, 0, 760, 398, BitOR($LVS_DEFAULT, $LVS_NOSORTHEADER), BitOR($WS_EX_TRANSPARENT, $WS_EX_WINDOWEDGE))
GUICtrlSetFont(-1, 8.5, 400, 0, 'Tahoma')
$hLV = GUICtrlGetHandle(-1)
_GUICtrlListView_SetExtendedListViewStyle($hLV, BitOR($LVS_EX_DOUBLEBUFFER, $LVS_EX_FULLROWSELECT, $LVS_EX_GRIDLINES, $LVS_EX_INFOTIP))
_GUICtrlListView_AddColumn($hLV, 'URL', 304)
_GUICtrlListView_AddColumn($hLV, 'Localtion', 204)
_GUICtrlListView_AddColumn($hLV, 'Progress', 55, 1)
_GUICtrlListView_AddColumn($hLV, 'Status', 90)
_GUICtrlListView_AddColumn($hLV, 'Error', 90)
GUICtrlCreateLabel('', 0, 398, 763, 2, $SS_ETCHEDHORZ)
$aButtons[0] = GUICtrlCreateButton('Download...', 5, 405, 248, 30)
GUICtrlSetState(-1, $GUI_FOCUS)
$aButtons[1] = GUICtrlCreateButton('Pause', 257, 405, 247, 30)
GUICtrlSetState(-1, $GUI_DISABLE)
$aButtons[2] = GUICtrlCreateButton('Remove', 508, 405, 247, 30)
GUICtrlSetState(-1, $GUI_DISABLE)
GUIRegisterMsg($WM_NOTIFY, 'WM_NOTIFY')
GUISetState()

While 1
	Switch GUIGetMsg()
		Case 0
			ContinueLoop
		Case $GUI_EVENT_CLOSE
			ExitLoop
		Case $aButtons[$iBttn_Download]
			Local $aJob = _SHDownloadDlg($hForm)
			
			If IsArray($aJob) Then
				Local $iTCPInet_ID = _LV_Add($aJob[0])
				
				If Not _TCPInet_GetFile($aJob[0], $aJob[1], True, $TCPINET_DOWNLOADBACKGROUND, '_TCPInet_Progress', $iTCPInet_ID) Then
					MsgBox(16, 'Error', 'Unable to start download.', 0, $hForm)
					_LV_Remove()
				EndIf
			EndIf
		Case $aButtons[$iBttn_Pause]
			_BN_Pause()
		Case $aButtons[$iBttn_Remove]
			_BN_Remove()
			_LV_Remove()
	EndSwitch
WEnd

Func _BN_Pause()
	Local $ID = _GUICtrlListView_GetItemParam($hLV, $iLV_ITEM)
	
	Switch $ID
		Case 1 To 65535
			_TCPInet_Pause($ID, Not _TCPInet_GetInfo($ID, $TCPINET_DOWNLOADPAUSED))
			_BN_Set($ID)
	EndSwitch
EndFunc ;==>_BN_Pause

Func _BN_Remove()
	Local $ID = _GUICtrlListView_GetItemParam($hLV, $iLV_ITEM)
	
	Switch $ID
		Case 1 To 65535
			_TCPInet_Close($ID)
	EndSwitch
EndFunc ;==>_BN_Remove

Func _BN_Set($ID)
	Local $Set[2], $Info = Default
	
	Switch $ID
		Case 1 To 65535
			$Info = _TCPInet_GetInfo($ID)
			If $Info[2] Then
				$Set[0] = 0
			Else
				$Set[0] = 1
			EndIf
			$Set[1] = 1
		Case Else
			$Set[0] = 0
			$Set[1] = 0
	EndSwitch
	
	For $i = 0 To 1
		If $Set[$i] Then
			If BitAND(GUICtrlGetState($aButtons[$i + 1]), $GUI_DISABLE) Then
				GUICtrlSetState($aButtons[$i + 1], $GUI_ENABLE)
			EndIf
			
			Switch $i
				Case 0
					If (Not IsArray($Info)) Or (Not $Info[5]) Then
						If GUICtrlRead($aButtons[$i + 1]) = 'Resume' Then
							GUICtrlSetData($aButtons[$iBttn_Pause], 'Pause')
						EndIf
					Else
						If GUICtrlRead($aButtons[$i + 1]) = 'Pause' Then
							GUICtrlSetData($aButtons[$iBttn_Pause], 'Resume')
						EndIf
					EndIf
			EndSwitch
		Else
			If BitAND(GUICtrlGetState($aButtons[$i + 1]), $GUI_ENABLE) Then
				GUICtrlSetState($aButtons[$i + 1], $GUI_DISABLE)
			EndIf
			
			Switch $i
				Case 0
					If GUICtrlRead($aButtons[$i + 1]) = 'Resume' Then
						GUICtrlSetData($aButtons[$iBttn_Pause], 'Pause')
					EndIf
			EndSwitch
		EndIf
	Next
	
	If Not _GUICtrlListView_GetItemCount($hLV) Then
		GUICtrlSetState($aButtons[0], $GUI_FOCUS)
	EndIf
EndFunc ;==>_BN_Set

Func _GetID()
	Local Static $ID = 65535
	
	If $ID = 2147483647 Then
		$ID = 65536
	Else
		$ID += 1
	EndIf
	
	Return $ID
EndFunc ;==>_GetID

Func _LV_Add($sUrl)
	Local $ID = _GetID()
	
	$fLV_UPDATED = True
	
	_GUICtrlListView_BeginUpdate($hLV)
	$iLV_ITEM = _GUICtrlListView_AddItem($hLV, $sUrl, -1, $ID)
	_GUICtrlListView_SetItemSelected($hLV, $iLV_ITEM, 1, 1)
	_GUICtrlListView_EnsureVisible($hLV, $iLV_ITEM)
	_GUICtrlListView_EndUpdate($hLV)
	_WinAPI_SetFocus($hLV)
	_BN_Set($ID)
	
	$fLV_UPDATED = False
	
	Return $ID
EndFunc ;==>_LV_Add

Func _LV_Remove()
	Local $ID = 0
	
	$fLV_UPDATED = True
	
	_GUICtrlListView_BeginUpdate($hLV)
	_GUICtrlListView_DeleteItem($hLV, $iLV_ITEM)
	
	If $iLV_ITEM > _GUICtrlListView_GetItemCount($hLV) - 1 Then
		$iLV_ITEM -= 1
	EndIf
	
	If $iLV_ITEM > -1 Then
		$ID = _GUICtrlListView_GetItemParam($hLV, $iLV_ITEM)
		_GUICtrlListView_SetItemSelected($hLV, $iLV_ITEM, 1, 1)
		_GUICtrlListView_EnsureVisible($hLV, $iLV_ITEM)
	EndIf
	
	_GUICtrlListView_EndUpdate($hLV)
	_BN_Set($ID)
	
	$fLV_UPDATED = False
EndFunc ;==>_LV_Remove

Func _SHDownloadDlg($hParent)
	Local $hDlg, $Button, $Input, $Msg
	Local $Job[2] = ['', '']
	
	Opt('GUICloseOnESC', 1)
	
	If $hParent Then
		GUISetState(@SW_DISABLE, $hParent)
	EndIf
	
	$hDlg = GUICreate('Add Location', 340, 97, -1, -1, BitOR($WS_CAPTION, $WS_POPUP, 0, $WS_SYSMENU), $WS_EX_DLGMODALFRAME, $hParent)
	GUICtrlCreateLabel('URL:', 14, 28, 27, 14)
	$Input = GUICtrlCreateInput('', 42, 25, 282, 19, BitOR($ES_AUTOHSCROLL, $ES_LEFT, $ES_MULTILINE))
	GUICtrlSetState(-1, $GUI_FOCUS)
	$Button = GUICtrlCreateButton('OK', 131, 62, 78, 25)
	GUICtrlSetState(-1, $GUI_DEFBUTTON)
	GUISetState(@SW_SHOW, $hDlg)
	
	While 1
		$Msg = GUIGetMsg()
		Switch $Msg
			Case 0
				ContinueLoop
			Case $GUI_EVENT_CLOSE
				ExitLoop
			Case $Button
				$Job[0] = StringStripWS(GUICtrlRead($Input), 8)
				
				If StringRegExp($Job[0], '(?i)^http://[^/]+/.+') Then
					ExitLoop
				EndIf
		EndSwitch
	WEnd
	
	If $hParent Then
		GUISetState(@SW_ENABLE, $hParent)
	EndIf
	
	GUIDelete($hDlg)
	Opt('GUICloseOnESC', 0)
	
	If $Job[0] Then
		$Job[1] = FileSelectFolder('', '::{20D04FE0-3AEA-1069-A2D8-08002B30309D}', 0, @WorkingDir, $hParent)
		
		If $Job[1] Then
			FileChangeDir($Job[1])
			$Job[1] = StringRegExpReplace($Job[1], '\\+$', '')
			Return $Job
		EndIf
	EndIf
	
	Return 0
EndFunc ;==>_SHDownloadDlg

Func _TCPInet_Progress($hInet, $iID)
	Local $Info = _TCPInet_GetInfo($hInet)
	Local $ID, $Index = -1
	Local $Data[3]
	
	For $i = 0 To _GUICtrlListView_GetItemCount($hLV) - 1
		$ID = _GUICtrlListView_GetItemParam($hLV, $i)
		
		If ($ID = $hInet) Or ($ID = $iID) Then
			$Index = $i
			
			If $ID > 65535 Then
				_GUICtrlListView_SetItemText($hLV, $Index, $Info[6], 1)
				_GUICtrlListView_SetItemParam($hLV, $Index, $hInet)
			EndIf
			
			ExitLoop
		EndIf
	Next
	
	If $Index = -1 Then
		Return $TCPINET_CB_CONTINUE
	EndIf
	
	If $Info[1] Then
		$Data[0] = Floor($Info[0] / $Info[1] * 100) & '%'
	Else
		If $Info[2] Then
			$Data[0] = '100%'
		Else
			$Data[0] = '?'
		EndIf
	EndIf
	
	If $Info[2] Then
		If $Info[3] Then
			$Data[1] = 'Complete'
			$Data[2] = '0'
		Else
			$Data[1] = 'Error'
			$Data[2] = String($Info[4])
		EndIf
	Else
		If $Info[5] Then
			$Data[1] = 'Pause'
		Else
			$Data[1] = 'Downloading'
		EndIf
	EndIf
	
	_GUICtrlListView_BeginUpdate($hLV)
	$Info = _GUICtrlListView_GetItemTextArray($hLV, $Index)
	
	For $i = 0 To 2
		If $Data[$i] <> $Info[$i + 2] Then
			_GUICtrlListView_SetItemText($hLV, $Index, $Data[$i], $i + 2)
		EndIf
	Next
	
	_GUICtrlListView_RedrawItems($hLV, $Index, $Index)
	_GUICtrlListView_EndUpdate($hLV)
	
	If $Index = $iLV_ITEM Then
		_BN_Set($ID)
	EndIf
	
	Return $TCPINET_CB_CONTINUE
EndFunc ;==>_Inet_Progress

Func WM_NOTIFY($hWnd, $iMsg, $wParam, $lParam)
	Local Static $Flag = False
	
	Local $uint = ''
	If @AutoItX64 Then $uint = 'uint;'
	
;~ 	Local $tNMLV = DllStructCreate($tagNMLISTVIEW , $lParam)
	Local $tNMLV = DllStructCreate('hwnd hWndFrom;uint_ptr IDFrom;int Code;' & $uint & 'int Item;int SubItem;uint NewState;uint OldState;uint Changed;long ActionX;long ActionY;lparam Param', $lParam)
	Local $hTarget = DllStructGetData($tNMLV, 'hWndFrom')
	Local $Code = DllStructGetData($tNMLV, 'Code')
	Local $Path
	
	Switch $hTarget
		Case $hLV
			Switch $Code
				Case $LVN_BEGINDRAG
					Return 0
				Case $LVN_ITEMACTIVATE
					If $iLV_ITEM > -1 Then
						$Path = _GUICtrlListView_GetItemText($hTarget, $iLV_ITEM, 1)
						
						If FileExists($Path) Then
							ShellExecute('explorer.exe', '/select,' & $Path)
						EndIf
					EndIf
				Case $LVN_ITEMCHANGED
					If $fLV_UPDATED Then
						Return $GUI_RUNDEFMSG
					EndIf
					
					If (BitAND(DllStructGetData($tNMLV, 'Changed'), $LVIF_STATE)) And (BitXOR(DllStructGetData($tNMLV, 'NewState'), DllStructGetData($tNMLV, 'OldState'))) Then
						If BitAND(DllStructGetData($tNMLV, 'NewState'), $LVIS_SELECTED) Then
							_BN_Set(DllStructGetData($tNMLV, 'Param'))
							$iLV_ITEM = DllStructGetData($tNMLV, 'Item')
							$Flag = 0
						Else
							If BitAND(DllStructGetData($tNMLV, 'OldState'), $LVIS_FOCUSED) Then
								$Flag = 1
							Else
								If Not $Flag Then
									_BN_Set(0)
									$iLV_ITEM = -1
								EndIf
								
								$Flag = 0
							EndIf
						EndIf
					EndIf
				Case $NM_CUSTOMDRAW
;~ 					Local $tNMLVCD = DllStructCreate($tagNMLVCUSTOMDRAW , $lParam)
					Local $tNMLVCD = DllStructCreate('hwnd hWndFrom;uint_ptr IDFrom;int Code;' & $uint & 'dword DrawStage;hwnd hDC;long Left;long Top;long Right;long Bottom;dword_ptr ItemSpec;uint ItemState;lparam ItemParam;dword clrText;dword clrTextBk;int SubItem;dword ItemType;dword clrFace;int IconEffect;int IconPhase;int PartId;int StateId;long TextLeft;long TextTop;long TextRight;long TextBottom;uint Align', $lParam)
					Local $Stage = DllStructGetData($tNMLVCD, 'DrawStage')
					Local $ID = DllStructGetData($tNMLVCD, 'ItemParam')
					Local $Info
					
					Switch $Stage
						Case $CDDS_ITEMPREPAINT
							Return $CDRF_NOTIFYSUBITEMDRAW
						Case BitOR($CDDS_ITEMPREPAINT, $CDDS_SUBITEM)
							Switch $ID
								Case 1 To 65535
									$Info = _TCPInet_GetInfo($ID)
									
									If $Info[2] Then
										If $Info[3] Then
											DllStructSetData($tNMLVCD, 'clrTextBk', 0x80FF80)
										Else
											DllStructSetData($tNMLVCD, 'clrTextBk', 0xAAAAFF)
										EndIf
									Else
										If $Info[5] Then
											DllStructSetData($tNMLVCD, 'clrTextBk', 0x99FFFF)
										EndIf
									EndIf
							EndSwitch
							
							Return $CDRF_DODEFAULT
					EndSwitch
				Case $NM_CLICK, $NM_DBLCLK, $NM_RCLICK, $NM_RDBLCLK
					Return 0
			EndSwitch
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc
